import { Arr } from '@ephox/katamari';

import { DieFn, NextFn } from '../pipe/Pipe';

import { Chain } from './Chain';
import { TestLogs } from './TestLogs';

export const compose = <A, B, C> (sab: Chain<A, B>, sbc: Chain<B, C>): Chain<A, C> =>
  // don't Pipe them - assume that the base actions have already been piped
  ({
    runChain: (a: A, next: NextFn<C>, die: DieFn, logs: TestLogs): void =>
      sab.runChain(a, (b: B, blogs) => sbc.runChain(b, next, die, blogs), die, logs)
  });

/*
Code partly generated in GHCi:

:m + Data.List
:m + Control.Monad
putStrLn $ intercalate " |\n" $ (\n -> (\x -> "[" ++ x ++ ", Chain<A" ++ (show n) ++ ", T>]") $ intercalate ", " $ (\m -> "Chain<A" ++ (show m) ++ ", A" ++ (show (m + 1)) ++ ">") <$> [1..n-1]) <$> [1..100]
 */
/* eslint-disable max-len */
export const sequence =
  <A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76, A77, A78, A79, A80, A81, A82, A83, A84, A85, A86, A87, A88, A89, A90, A91, A92, A93, A94, A95, A96, A97, A98, A99, A100, T>
  (Chains:
  [] |
  [Chain<A1, T>] |
  [Chain<A1, A2>, Chain<A2, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, A95>, Chain<A95, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, A95>, Chain<A95, A96>, Chain<A96, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, A95>, Chain<A95, A96>, Chain<A96, A97>, Chain<A97, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, A95>, Chain<A95, A96>, Chain<A96, A97>, Chain<A97, A98>, Chain<A98, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, A95>, Chain<A95, A96>, Chain<A96, A97>, Chain<A97, A98>, Chain<A98, A99>, Chain<A99, T>] |
  [Chain<A1, A2>, Chain<A2, A3>, Chain<A3, A4>, Chain<A4, A5>, Chain<A5, A6>, Chain<A6, A7>, Chain<A7, A8>, Chain<A8, A9>, Chain<A9, A10>, Chain<A10, A11>, Chain<A11, A12>, Chain<A12, A13>, Chain<A13, A14>, Chain<A14, A15>, Chain<A15, A16>, Chain<A16, A17>, Chain<A17, A18>, Chain<A18, A19>, Chain<A19, A20>, Chain<A20, A21>, Chain<A21, A22>, Chain<A22, A23>, Chain<A23, A24>, Chain<A24, A25>, Chain<A25, A26>, Chain<A26, A27>, Chain<A27, A28>, Chain<A28, A29>, Chain<A29, A30>, Chain<A30, A31>, Chain<A31, A32>, Chain<A32, A33>, Chain<A33, A34>, Chain<A34, A35>, Chain<A35, A36>, Chain<A36, A37>, Chain<A37, A38>, Chain<A38, A39>, Chain<A39, A40>, Chain<A40, A41>, Chain<A41, A42>, Chain<A42, A43>, Chain<A43, A44>, Chain<A44, A45>, Chain<A45, A46>, Chain<A46, A47>, Chain<A47, A48>, Chain<A48, A49>, Chain<A49, A50>, Chain<A50, A51>, Chain<A51, A52>, Chain<A52, A53>, Chain<A53, A54>, Chain<A54, A55>, Chain<A55, A56>, Chain<A56, A57>, Chain<A57, A58>, Chain<A58, A59>, Chain<A59, A60>, Chain<A60, A61>, Chain<A61, A62>, Chain<A62, A63>, Chain<A63, A64>, Chain<A64, A65>, Chain<A65, A66>, Chain<A66, A67>, Chain<A67, A68>, Chain<A68, A69>, Chain<A69, A70>, Chain<A70, A71>, Chain<A71, A72>, Chain<A72, A73>, Chain<A73, A74>, Chain<A74, A75>, Chain<A75, A76>, Chain<A76, A77>, Chain<A77, A78>, Chain<A78, A79>, Chain<A79, A80>, Chain<A80, A81>, Chain<A81, A82>, Chain<A82, A83>, Chain<A83, A84>, Chain<A84, A85>, Chain<A85, A86>, Chain<A86, A87>, Chain<A87, A88>, Chain<A88, A89>, Chain<A89, A90>, Chain<A90, A91>, Chain<A91, A92>, Chain<A92, A93>, Chain<A93, A94>, Chain<A94, A95>, Chain<A95, A96>, Chain<A96, A97>, Chain<A97, A98>, Chain<A98, A99>, Chain<A99, A100>, Chain<A100, T>]
  ): Chain<A1, T> => {
    const s = Chains as Chain<any, any>[];
    return sequenceUnsafe(s);
  };
/* eslint-enable max-len */

export const sequenceSame = <T> (Chains: Chain<T, T>[]): Chain<T, T> =>
  sequenceUnsafe(Chains);

export const sequenceUnsafe = (Chains: Chain<any, any>[]): Chain<any, any> =>
  Chains.length === 0 ? Chain.identity : Arr.foldl(Chains, (acc, Chain) => compose(acc, Chain), Chain.identity);
